"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MarkerLayerContext = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const markerLayerProps = {
  maintainHistory: _propTypes.default.bool,
  persistent: _propTypes.default.bool
};

const MarkerLayerContext = _react.default.createContext();

exports.MarkerLayerContext = MarkerLayerContext;

class BareMarkerLayer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'createLayer');
    this.subs = new _eventKit.CompositeDisposable();
    this.layerSub = new _eventKit.Disposable();
    this.layerHolder = new _refHolder.default();
    this.state = {
      editorHolder: _refHolder.default.on(this.props.editor)
    };
    this.decorable = {
      holder: this.layerHolder,
      decorateMethod: 'decorateMarkerLayer'
    };
  }

  static getDerivedStateFromProps(props, state) {
    if (state.editorHolder.map(e => e === props.editor).getOr(props.editor === undefined)) {
      return null;
    }

    return {
      editorHolder: _refHolder.default.on(props.editor)
    };
  }

  componentDidMount() {
    this.observeEditor();
  }

  render() {
    return _react.default.createElement(MarkerLayerContext.Provider, {
      value: this.layerHolder
    }, _react.default.createElement(_marker.DecorableContext.Provider, {
      value: this.decorable
    }, this.props.children));
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.state.editorHolder !== prevState.editorHolder) {
      this.observeEditor();
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeEditor() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.state.editorHolder.observe(this.createLayer));
  }

  createLayer() {
    this.subs.remove(this.layerSub);
    this.layerSub.dispose();
    this.state.editorHolder.map(editor => {
      const options = (0, _helpers.extractProps)(this.props, markerLayerProps);
      let layer;

      if (this.props.external !== undefined) {
        layer = editor.getMarkerLayer(this.props.external.id);

        if (!layer) {
          return null;
        }

        if (layer !== this.props.external && layer.bufferMarkerLayer !== this.props.external) {
          // Oops, same layer ID on a different TextEditor
          return null;
        }

        this.layerSub = new _eventKit.Disposable();
      } else {
        layer = editor.addMarkerLayer(options);
        this.layerSub = new _eventKit.Disposable(() => {
          layer.destroy();
          this.props.handleLayer(undefined);
          this.props.handleID(undefined);
        });
      }

      this.layerHolder.setter(layer);
      this.props.handleLayer(layer);
      this.props.handleID(layer.id);
      this.subs.add(this.layerSub);
      return null;
    });
  }

}

_defineProperty(BareMarkerLayer, "propTypes", _objectSpread2({}, markerLayerProps, {
  editor: _propTypes.default.object,
  external: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }),
  children: _propTypes.default.node,
  handleID: _propTypes.default.func,
  handleLayer: _propTypes.default.func
}));

_defineProperty(BareMarkerLayer, "defaultProps", {
  handleID: () => {},
  handleLayer: () => {}
});

class MarkerLayer extends _react.default.Component {
  render() {
    return _react.default.createElement(_atomTextEditor.TextEditorContext.Consumer, null, editor => _react.default.createElement(BareMarkerLayer, _extends({
      editor: editor
    }, this.props)));
  }

}

exports.default = MarkerLayer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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