/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGridHandler {
    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChain(MechanicalCrafterTileEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterTileEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChainIf(MechanicalCrafterTileEntity root, Predicate<MechanicalCrafterTileEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterTileEntity> getAllCraftersOfChainIf(MechanicalCrafterTileEntity root, Predicate<MechanicalCrafterTileEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterTileEntity> crafters = new ArrayList<MechanicalCrafterTileEntity>();
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<MechanicalCrafterTileEntity> visited = new HashSet<MechanicalCrafterTileEntity>();
        frontier.add(Pair.of((Object)root, null));
        boolean powered = false;
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.remove(0);
            MechanicalCrafterTileEntity current = (MechanicalCrafterTileEntity)pair.getKey();
            MechanicalCrafterTileEntity last = (MechanicalCrafterTileEntity)pair.getValue();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            if (poweredStart && current.func_145831_w().func_175640_z(current.func_174877_v())) {
                powered = true;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterTileEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of((Object)target, (Object)current));
            }
            for (MechanicalCrafterTileEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of((Object)preceding, (Object)current));
            }
        }
        return empty && !powered || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterTileEntity getTargetingCrafter(MechanicalCrafterTileEntity crafter) {
        BlockState state = crafter.func_195044_w();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        BlockPos targetPos = crafter.func_174877_v().func_177972_a(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterTileEntity targetTE = CrafterHelper.getCrafter((IBlockDisplayReader)crafter.func_145831_w(), targetPos);
        if (targetTE == null) {
            return null;
        }
        BlockState targetState = targetTE.func_195044_w();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetTE;
    }

    public static List<MechanicalCrafterTileEntity> getPrecedingCrafters(MechanicalCrafterTileEntity crafter) {
        BlockPos pos = crafter.func_174877_v();
        World world = crafter.func_145831_w();
        ArrayList<MechanicalCrafterTileEntity> crafters = new ArrayList<MechanicalCrafterTileEntity>();
        BlockState blockState = crafter.func_195044_w();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        Direction blockFacing = (Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
        Direction blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (Direction facing : Iterate.directions) {
            MechanicalCrafterTileEntity te;
            BlockPos neighbourPos;
            BlockState neighbourState;
            if (blockFacing.func_176740_k() == facing.func_176740_k() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.func_180495_p(neighbourPos = pos.func_177972_a(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.func_176734_d() || blockFacing != neighbourState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING) || (te = CrafterHelper.getCrafter((IBlockDisplayReader)world, neighbourPos)) == null) continue;
            crafters.add(te);
        }
        return crafters;
    }

    private static boolean isCrafter(BlockState state) {
        return AllBlocks.MECHANICAL_CRAFTER.has(state);
    }

    public static ItemStack tryToApplyRecipe(World world, GroupedItems items) {
        items.calcStats();
        MechanicalCraftingInventory craftinginventory = new MechanicalCraftingInventory(items);
        ItemStack result = null;
        if (((Boolean)AllConfigs.SERVER.recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftinginventory, world).map(r -> r.func_77572_b((IInventory)craftinginventory)).orElse(null);
        }
        if (result == null) {
            result = AllRecipeTypes.MECHANICAL_CRAFTING.find(craftinginventory, world).map(r -> r.func_77572_b((IInventory)craftinginventory)).orElse(null);
        }
        return result;
    }

    public static class GroupedItems {
        Map<Pair<Integer, Integer>, ItemStack> grid = new HashMap<Pair<Integer, Integer>, ItemStack>();
        int minX;
        int minY;
        int maxX;
        int maxY;
        int width;
        int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(ItemStack stack) {
            this.grid.put((Pair<Integer, Integer>)Pair.of((Object)0, (Object)0), stack);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put((Pair<Integer, Integer>)Pair.of((Object)((Integer)pair.getKey() + xOffset), (Object)((Integer)pair.getValue() + yOffset)), (ItemStack)stack));
            other.statsReady = false;
        }

        public void write(CompoundNBT nbt) {
            ListNBT gridNBT = new ListNBT();
            this.grid.forEach((pair, stack) -> {
                CompoundNBT entry = new CompoundNBT();
                entry.func_74768_a("x", ((Integer)pair.getKey()).intValue());
                entry.func_74768_a("y", ((Integer)pair.getValue()).intValue());
                entry.func_218657_a("item", (INBT)stack.serializeNBT());
                gridNBT.add((Object)entry);
            });
            nbt.func_218657_a("Grid", (INBT)gridNBT);
        }

        public static GroupedItems read(CompoundNBT nbt) {
            GroupedItems items = new GroupedItems();
            ListNBT gridNBT = nbt.func_150295_c("Grid", 10);
            gridNBT.forEach(inbt -> {
                CompoundNBT entry = (CompoundNBT)inbt;
                int x = entry.func_74762_e("x");
                int y = entry.func_74762_e("y");
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)entry.func_74775_l("item"));
                items.grid.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = (Integer)pair.getKey();
                int y = (Integer)pair.getValue();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }
    }
}

