/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.foundation.command.HighlightPacket;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.PacketDistributor;

public class HighlightCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"highlight").requires(cs -> cs.func_197034_c(0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)ctx, (String)"players");
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos");
            for (ServerPlayerEntity p : players) {
                AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> p), (Object)new HighlightPacket(pos));
            }
            return players.size();
        }))).executes(ctx -> {
            BlockPos pos = BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"pos");
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)((CommandSource)ctx.getSource()).func_197022_f()), (Object)new HighlightPacket(pos));
            return 1;
        }))).executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            return HighlightCommand.highlightAssemblyExceptionFor(player, (CommandSource)ctx.getSource());
        });
    }

    private static void sendMissMessage(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Try looking at a Block that has failed to assemble a Contraption and try again."), true);
    }

    private static int highlightAssemblyExceptionFor(ServerPlayerEntity player, CommandSource source) {
        double distance = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d start = player.func_174824_e(1.0f);
        Vector3d look = player.func_70676_i(1.0f);
        World world = player.field_70170_p;
        Vector3d end = start.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (ray.func_216346_c() == RayTraceResult.Type.MISS) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        BlockPos pos = ray.func_216350_a();
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IDisplayAssemblyExceptions)) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        IDisplayAssemblyExceptions display = (IDisplayAssemblyExceptions)te;
        AssemblyException exception = display.getLastAssemblyException();
        if (exception == null) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        if (!exception.hasPosition()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Can't highlight a specific position for this issue"), true);
            return 1;
        }
        BlockPos p = exception.getPosition();
        String command = "/create highlight " + p.func_177958_n() + " " + p.func_177956_o() + " " + p.func_177952_p();
        return player.field_71133_b.func_195571_aL().func_197059_a(source, command);
    }
}

