/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.EntityElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class DeployerScenes {
    public static void filter(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer", "Using the Deployer");
        scene.configureBasePlate(0, 0, 5);
        BlockPos potPosition = util.grid.at(1, 1, 2);
        BlockPos deployerPos = util.grid.at(3, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.setBlock(potPosition, Blocks.field_150350_a.func_176223_P(), false);
        scene.world.showSection(util.select.layer(0).add(util.select.position(1, 1, 2)), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(deployerSelection, Direction.SOUTH);
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.topOf(deployerPos)).text("Given Rotational Force, a Deployer can imitate player interactions");
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(44);
        scene.overlay.showSelectionWithText(util.select.position(deployerPos.func_177985_f(2)), 60).text("It will always interact with the position 2 blocks in front of itself").attachKeyFrame().placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 1), Direction.DOWN);
        scene.idle(24);
        scene.overlay.showText(50).pointAt(util.vector.topOf(deployerPos.func_177976_e())).text("Blocks directly in front will not obstruct it").placeNearTarget();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(34);
        scene.world.hideSection(util.select.fromTo(2, 1, 3, 2, 1, 1), Direction.UP);
        scene.idle(20);
        String[] actions = new String[]{"Place Blocks,", "Use Items,", "Activate Blocks,", "Harvest blocks", "and Attack Mobs"};
        scene.overlay.showText(80).attachKeyFrame().independent(40).placeNearTarget().text("Deployers can:");
        int y = 60;
        for (String s : actions) {
            scene.idle(15);
            scene.overlay.showText(50).colored(PonderPalette.MEDIUM).placeNearTarget().independent(y).text(s);
            y += 16;
        }
        scene.idle(50);
        ItemStack pot = new ItemStack((IItemProvider)Items.field_222087_nH);
        Vector3d frontVec = util.vector.blockSurface(deployerPos, Direction.WEST).func_72441_c(-0.125, 0.0, 0.0);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.DOWN).rightClick().withItem(pot), 40);
        scene.idle(7);
        Class<DeployerTileEntity> teType = DeployerTileEntity.class;
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)pot.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(frontVec).text("Right-click the front to give it an Item to use");
        scene.idle(40);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.restoreBlocks(util.select.position(potPosition));
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)ItemStack.field_190927_a.serializeNBT()));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.func_177984_a()), Direction.DOWN);
        ItemStack tulip = new ItemStack((IItemProvider)Items.field_221624_aZ);
        Vector3d entitySpawn = util.vector.topOf(deployerPos.func_177981_b(3));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), tulip);
        scene.idle(17);
        scene.world.modifyEntity(entity1, Entity::func_70106_y);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)tulip.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Items can also be inserted automatically");
        scene.idle(30);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.setBlock(potPosition, Blocks.field_196734_em.func_176223_P(), false);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)ItemStack.field_190927_a.serializeNBT()));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(25);
        scene.world.hideSection(util.select.position(potPosition), Direction.UP);
        scene.world.hideSection(util.select.position(deployerPos.func_177984_a()), Direction.EAST);
        scene.idle(20);
        Vector3d filterSlot = frontVec.func_72441_c(0.375, 0.25, 0.0);
        scene.overlay.showFilterSlotInput(filterSlot, 80);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("Deployers carry a filter slot");
        scene.idle(50);
        ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).rightClick().withItem(shears), 40);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, teType, shears);
        scene.overlay.showText(60).placeNearTarget().pointAt(filterSlot).text("When a filter is set, it activates only while holding a matching item");
        scene.idle(70);
        ElementLink<EntityElement> sheep = scene.world.createEntity(w -> {
            SheepEntity entity = (SheepEntity)EntityType.field_200737_ac.func_200721_a(w);
            entity.func_175512_b(DyeColor.PINK);
            Vector3d p = util.vector.topOf(util.grid.at(1, 0, 2));
            entity.func_70107_b(p.field_72450_a, p.field_72448_b, p.field_72449_c);
            entity.field_70169_q = p.field_72450_a;
            entity.field_70167_r = p.field_72448_b;
            entity.field_70166_s = p.field_72449_c;
            entity.field_184619_aG = 0.0f;
            entity.field_70126_B = 210.0f;
            entity.field_70177_z = 210.0f;
            entity.field_70758_at = 210.0f;
            entity.field_70759_as = 210.0f;
            return entity;
        });
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.func_177984_a()), Direction.WEST);
        entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), shears);
        scene.idle(17);
        scene.world.modifyEntity(entity1, Entity::func_70106_y);
        scene.world.modifyTileNBT(deployerSelection, teType, nbt -> nbt.func_218657_a("HeldItem", (INBT)shears.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Only items matching the filter can now be inserted...");
        scene.idle(70);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.modifyEntity(sheep, e -> ((SheepEntity)e).func_70893_e(true));
        scene.effects.emitParticles(util.vector.topOf(deployerPos.func_177985_f(2)).func_72441_c(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace(new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196562_aR.func_176223_P()), util.vector.of(0.0, 0.0, 0.0)), 25.0f, 1);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.world.showSection(util.select.position(deployerPos.func_177978_c()), Direction.SOUTH);
        scene.idle(25);
        scene.overlay.showText(80).placeNearTarget().pointAt(util.vector.of(3.5, 1.25, 1.25)).text("...and only non-matching items will be extracted");
        scene.world.flapFunnel(deployerPos.func_177978_c(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.func_177978_c()).func_178786_a(0.0, 0.45, 0.0), util.vector.of(0.0, 0.0, -0.1), new ItemStack((IItemProvider)Items.field_221609_aK));
        scene.markAsFinished();
        for (int i = 0; i < 10; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            scene.idle(26);
        }
    }

    public static void modes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_modes", "Modes of the Deployer");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), Direction.DOWN);
        scene.idle(10);
        BlockPos deployerPos = util.grid.at(3, 1, 2);
        Vector3d frontVec = util.vector.blockSurface(deployerPos, Direction.WEST).func_72441_c(-0.125, 0.0, 0.0);
        Selection grassBlock = util.select.position(1, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.showSection(deployerSelection, Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(grassBlock, Direction.DOWN);
        scene.idle(10);
        ItemStack tool = new ItemStack((IItemProvider)Items.field_151013_M);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(deployerPos), Pointing.DOWN).withItem(tool), 30);
        scene.idle(7);
        scene.world.modifyTileNBT(deployerSelection, DeployerTileEntity.class, nbt -> nbt.func_218657_a("HeldItem", (INBT)tool.serializeNBT()));
        scene.idle(45);
        scene.world.setKineticSpeed(util.select.position(2, 0, 5), 16.0f);
        scene.world.setKineticSpeed(util.select.layer(1), -32.0f);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("By default, a Deployer imitates a Right-click interaction");
        scene.idle(26);
        scene.world.replaceBlocks(grassBlock, Blocks.field_150458_ak.func_176223_P(), false);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(46);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.LEFT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyTileNBT(deployerSelection, DeployerTileEntity.class, nbt -> nbt.func_74778_a("Mode", "PUNCH"));
        scene.idle(45);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("Using a Wrench, it can be set to imitate a Left-click instead");
        BlockPos breakingPos = deployerPos.func_177985_f(2);
        for (int i = 0; i < 4; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            if (i == 3) {
                scene.world.createItemEntity(util.vector.centerOf(breakingPos), util.vector.of(0.0, 0.0, 0.0), new ItemStack((IItemProvider)Blocks.field_150346_d));
            }
            scene.idle(26);
            if (i != 0) continue;
            scene.markAsFinished();
        }
    }

    public static void redstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_redstone", "Controlling Deployers with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 3, 1, 3), Direction.DOWN);
        BlockPos deployerPos = util.grid.at(3, 1, 3);
        Selection redstone = util.select.fromTo(3, 1, 1, 3, 1, 2);
        BlockPos leverPos = util.grid.at(3, 1, 1);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.world.showSection(redstone, Direction.SOUTH);
        scene.idle(31);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(10);
        scene.overlay.showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("When powered by Redstone, Deployers will not activate");
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(10);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(10);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(21);
        scene.overlay.showText(60).pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Before stopping, the Deployer will finish any started cycles");
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(3);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.overlay.showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
    }

    public static void contraption(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_contraption", "Using Deployers on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        Selection flowers = util.select.fromTo(4, 1, 1, 1, 1, 1);
        scene.world.replaceBlocks(flowers, Blocks.field_150350_a.func_176223_P(), false);
        Selection kinetics = util.select.fromTo(5, 1, 6, 5, 1, 3);
        BlockPos deployerPos = util.grid.at(4, 1, 3);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.showSection(util.select.layer(0).add(flowers), Direction.UP);
        scene.idle(5);
        ElementLink<WorldSectionElement> pistonHead = scene.world.showIndependentSection(util.select.fromTo(5, 1, 2, 8, 1, 2), Direction.DOWN);
        scene.world.moveSection(pistonHead, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.world.showSection(kinetics, Direction.DOWN);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(deployerSelection, Direction.DOWN);
        scene.idle(5);
        scene.world.glueBlockOnto(util.grid.at(4, 2, 3), Direction.DOWN, contraption);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(deployerPos, Direction.WEST)).text("Whenever Deployers are moved as part of an animated Contraption...");
        scene.idle(70);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), -8.0f);
        scene.world.setKineticSpeed(kinetics, 16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(-3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(-3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.restoreBlocks(util.select.position(4 - x, 1, 1));
            scene.idle(18);
        }
        scene.overlay.showSelectionWithText(flowers, 90).attachKeyFrame().colored(PonderPalette.GREEN).text("They activate at each visited location, using items from inventories anywhere on the contraption");
        scene.idle(100);
        scene.world.hideSection(flowers, Direction.UP);
        scene.idle(15);
        scene.world.replaceBlocks(flowers, Blocks.field_150350_a.func_176223_P(), false);
        scene.world.showSection(flowers, Direction.UP);
        Vector3d frontVec = util.vector.blockSurface(deployerPos.func_177985_f(3), Direction.NORTH).func_72441_c(0.0, 0.0, -0.125);
        Vector3d filterSlot = frontVec.func_72441_c(0.0, 0.25, 0.375);
        scene.overlay.showFilterSlotInput(filterSlot, 80);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("The Filter slot can be used to specify which items to pull");
        scene.idle(70);
        ItemStack poppy = new ItemStack((IItemProvider)Items.field_221620_aV);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).withItem(poppy), 30);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, DeployerTileEntity.class, poppy);
        scene.idle(25);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), 8.0f);
        scene.world.setKineticSpeed(kinetics, -16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.setBlock(util.grid.at(1 + x, 1, 1), Blocks.field_196606_bd.func_176223_P(), false);
            scene.idle(18);
        }
    }
}

