/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PonderIndexScreen
extends NavigatableSimiScreen {
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.3;
    protected Rectangle2d chapterArea;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    private double itemYmult = 0.75;
    protected Rectangle2d itemArea;
    private ItemStack hoveredItem = ItemStack.field_190927_a;

    public PonderIndexScreen() {
        this.chapters = new ArrayList<PonderChapter>();
        this.items = new ArrayList<Item>();
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        this.chapters.clear();
        this.items.clear();
        PonderRegistry.all.keySet().stream().map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.func_199767_j();
            }
            return item;
        }).filter(Objects::nonNull).filter(PonderIndexScreen::exclusions).forEach(this.items::add);
        boolean hasChapters = !this.chapters.isEmpty();
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.chapters.size(), MathHelper.func_76125_a((int)((int)Math.ceil((float)this.chapters.size() / 4.0f)), (int)1, (int)4), 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.field_230708_k_ * 0.5);
        int chapterCenterY = (int)((double)this.field_230709_l_ * 0.3);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.widgets.add(label);
            layout.next();
        }
        if (!hasChapters) {
            this.itemYmult = 0.5;
        }
        int maxItemRows = hasChapters ? 4 : 7;
        layout = LayoutHelper.centeredHorizontal(this.items.size(), MathHelper.func_76125_a((int)((int)Math.ceil((float)this.items.size() / 11.0f)), (int)1, (int)maxItemRows), 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_230708_k_ * 0.5);
        int itemCenterY = (int)((double)this.field_230709_l_ * this.itemYmult);
        for (Item item : this.items) {
            PonderButton button = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4, (x, y) -> {
                if (!PonderRegistry.all.containsKey(item.getRegistryName())) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack((IItemProvider)item)));
            }).showing(new ItemStack((IItemProvider)item));
            button.fade(1.0f);
            this.widgets.add(button);
            layout.next();
        }
    }

    private static boolean exclusions(Item item) {
        Block block;
        return !(item instanceof BlockItem) || !((block = ((BlockItem)item).func_179223_d()) instanceof ValveHandleBlock) || AllBlocks.COPPER_VALVE_HANDLE.is(item);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.field_190927_a;
        MainWindow w = this.field_230706_i_.func_228018_at_();
        double mouseX = this.field_230706_i_.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.field_230706_i_.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof PonderButton) || !widget.func_231047_b_(mouseX, mouseY)) continue;
            this.hoveredItem = ((PonderButton)widget).getItem();
        }
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = (int)((double)this.field_230708_k_ * 0.5);
        int y = (int)((double)this.field_230709_l_ * 0.3);
        if (!this.chapters.isEmpty()) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)x, (double)y, 0.0);
            UIRenderHelper.streak(ms, 0.0f, this.chapterArea.func_199318_a() - 10, this.chapterArea.func_199319_b() - 20, 20, 220, 0x101010);
            this.field_230712_o_.func_238421_b_(ms, "Topics to Ponder about", (float)(this.chapterArea.func_199318_a() - 5), (float)(this.chapterArea.func_199319_b() - 25), -2232577);
            ms.func_227865_b_();
        }
        x = (int)((double)this.field_230708_k_ * 0.5);
        y = (int)((double)this.field_230709_l_ * this.itemYmult);
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        UIRenderHelper.streak(ms, 0.0f, this.itemArea.func_199318_a() - 10, this.itemArea.func_199319_b() - 20, 20, 220, 0x101010);
        this.field_230712_o_.func_238421_b_(ms, "Items to inspect", (float)(this.itemArea.func_199318_a() - 5), (float)(this.itemArea.func_199319_b() - 25), -2232577);
        ms.func_227865_b_();
    }

    @Override
    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.func_190926_b()) {
            return;
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 200.0);
        this.func_230457_a_(ms, this.hoveredItem, mouseX, mouseY);
        ms.func_227865_b_();
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        MutableBoolean handled = new MutableBoolean(false);
        this.widgets.forEach(w -> {
            if (handled.booleanValue()) {
                return;
            }
            if (!w.func_231047_b_(x, y)) {
                return;
            }
            if (w instanceof PonderButton) {
                PonderButton btn = (PonderButton)((Object)w);
                btn.runCallback(x, y);
                handled.setTrue();
            }
        });
        if (handled.booleanValue()) {
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }
}

