/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MinecartElement
extends AnimatedSceneElement {
    private Vector3d location;
    private LerpedFloat rotation;
    private AbstractMinecartEntity entity;
    private MinecartConstructor constructor;
    private float initialRotation;

    public MinecartElement(Vector3d location, float rotation, MinecartConstructor constructor) {
        this.initialRotation = rotation;
        this.location = location.func_72441_c(0.0, 0.0625, 0.0);
        this.constructor = constructor;
        this.rotation = LerpedFloat.angular().startWithValue(rotation);
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.entity.func_226288_n_(0.0, 0.0, 0.0);
        this.entity.field_70169_q = 0.0;
        this.entity.field_70167_r = 0.0;
        this.entity.field_70166_s = 0.0;
        this.entity.field_70142_S = 0.0;
        this.entity.field_70137_T = 0.0;
        this.entity.field_70136_U = 0.0;
        this.rotation.startWithValue(this.initialRotation);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.constructor.create(scene.getWorld(), 0.0, 0.0, 0.0);
        }
        ++this.entity.field_70173_aa;
        this.entity.field_70122_E = true;
        this.entity.field_70169_q = this.entity.func_226277_ct_();
        this.entity.field_70167_r = this.entity.func_226278_cu_();
        this.entity.field_70166_s = this.entity.func_226281_cx_();
        this.entity.field_70142_S = this.entity.func_226277_ct_();
        this.entity.field_70137_T = this.entity.func_226278_cu_();
        this.entity.field_70136_U = this.entity.func_226281_cx_();
    }

    public void setPositionOffset(Vector3d position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        if (!immediate) {
            return;
        }
        this.entity.field_70169_q = position.field_72450_a;
        this.entity.field_70167_r = position.field_72448_b;
        this.entity.field_70166_s = position.field_72449_c;
    }

    public void setRotation(float angle, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.rotation.setValue(angle);
        if (!immediate) {
            return;
        }
        this.rotation.startWithValue(angle);
    }

    public Vector3d getPositionOffset() {
        return this.entity != null ? this.entity.func_213303_ch() : Vector3d.field_186680_a;
    }

    public Vector3d getRotation() {
        return new Vector3d(0.0, (double)this.rotation.getValue(), 0.0);
    }

    @Override
    protected void renderLast(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        if (this.entity == null) {
            this.entity = this.constructor.create(world, 0.0, 0.0, 0.0);
        }
        ms.func_227860_a_();
        ms.func_227861_a_(this.location.field_72450_a, this.location.field_72448_b, this.location.field_72449_c);
        ms.func_227861_a_(MathHelper.func_219803_d((double)pt, (double)this.entity.field_70169_q, (double)this.entity.func_226277_ct_()), MathHelper.func_219803_d((double)pt, (double)this.entity.field_70167_r, (double)this.entity.func_226278_cu_()), MathHelper.func_219803_d((double)pt, (double)this.entity.field_70166_s, (double)this.entity.func_226281_cx_()));
        MatrixStacker.of(ms).rotateY(this.rotation.getValue(pt));
        entityrenderermanager.func_229084_a_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.func_227865_b_();
    }

    public static interface MinecartConstructor {
        public AbstractMinecartEntity create(World var1, double var2, double var4, double var6);
    }
}

