/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.simibubi.create.content.contraptions.base.KineticRenderMaterials;
import com.simibubi.create.content.contraptions.base.RotatingModel;
import com.simibubi.create.content.contraptions.relays.belt.BeltInstancedModel;
import com.simibubi.create.content.logistics.block.FlapModel;
import com.simibubi.create.foundation.render.AllProgramSpecs;
import com.simibubi.create.foundation.render.backend.MaterialTypes;
import com.simibubi.create.foundation.render.backend.core.OrientedModel;
import com.simibubi.create.foundation.render.backend.core.TransformedModel;
import com.simibubi.create.foundation.render.backend.gl.BasicProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderCallback;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import java.util.ArrayList;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class KineticRenderer
extends InstancedTileRenderer<BasicProgram> {
    public static int MAX_ORIGIN_DISTANCE = 100;
    public BlockPos originCoordinate = BlockPos.field_177992_a;

    @Override
    public void registerMaterials() {
        this.materials.put(MaterialTypes.TRANSFORMED, new RenderMaterial<BasicProgram, TransformedModel>(this, AllProgramSpecs.MODEL, TransformedModel::new));
        this.materials.put(MaterialTypes.ORIENTED, new RenderMaterial<BasicProgram, OrientedModel>(this, AllProgramSpecs.ORIENTED, OrientedModel::new));
        this.materials.put(KineticRenderMaterials.BELTS, new RenderMaterial<BasicProgram, BeltInstancedModel>(this, AllProgramSpecs.BELT, BeltInstancedModel::new));
        this.materials.put(KineticRenderMaterials.ROTATING, new RenderMaterial<BasicProgram, RotatingModel>(this, AllProgramSpecs.ROTATING, RotatingModel::new));
        this.materials.put(KineticRenderMaterials.FLAPS, new RenderMaterial<BasicProgram, FlapModel>(this, AllProgramSpecs.FLAPS, FlapModel::new));
    }

    @Override
    public BlockPos getOriginCoordinate() {
        return this.originCoordinate;
    }

    @Override
    public void beginFrame(ActiveRenderInfo info, double cameraX, double cameraY, double cameraZ) {
        int cX = MathHelper.func_76128_c((double)cameraX);
        int cY = MathHelper.func_76128_c((double)cameraY);
        int cZ = MathHelper.func_76128_c((double)cameraZ);
        int dX = Math.abs(cX - this.originCoordinate.func_177958_n());
        int dY = Math.abs(cY - this.originCoordinate.func_177956_o());
        int dZ = Math.abs(cZ - this.originCoordinate.func_177952_p());
        if (dX > MAX_ORIGIN_DISTANCE || dY > MAX_ORIGIN_DISTANCE || dZ > MAX_ORIGIN_DISTANCE) {
            this.originCoordinate = new BlockPos(cX, cY, cZ);
            ArrayList instancedTiles = new ArrayList(this.instances.keySet());
            this.invalidate();
            instancedTiles.forEach(this::add);
        }
        super.beginFrame(info, cameraX, cameraY, cameraZ);
    }

    @Override
    public void render(RenderType layer, Matrix4f viewProjection, double camX, double camY, double camZ, ShaderCallback<BasicProgram> callback) {
        BlockPos originCoordinate = this.getOriginCoordinate();
        Matrix4f translate = Matrix4f.func_226599_b_((float)((float)(-(camX -= (double)originCoordinate.func_177958_n()))), (float)((float)(-(camY -= (double)originCoordinate.func_177956_o()))), (float)((float)(-(camZ -= (double)originCoordinate.func_177952_p()))));
        translate.multiplyBackward(viewProjection);
        super.render(layer, translate, camX, camY, camZ, callback);
    }
}

