/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.versioned;

import com.simibubi.create.foundation.render.backend.gl.versioned.GlVersioned;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.opengl.ARBMapBufferRange;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

public enum MapBuffer implements GlVersioned
{
    GL30_RANGE{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.OpenGL30;
        }

        @Override
        public void mapBuffer(int target, int offset, int length, Consumer<ByteBuffer> upload) {
            ByteBuffer buffer = GL30.glMapBufferRange((int)target, (long)offset, (long)length, (int)2);
            upload.accept(buffer);
            buffer.rewind();
            GL30.glUnmapBuffer((int)target);
        }
    }
    ,
    ARB_RANGE{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.GL_ARB_map_buffer_range;
        }

        @Override
        public void mapBuffer(int target, int offset, int length, Consumer<ByteBuffer> upload) {
            ByteBuffer buffer = ARBMapBufferRange.glMapBufferRange((int)target, (long)offset, (long)length, (int)2);
            upload.accept(buffer);
            buffer.rewind();
            GL30.glUnmapBuffer((int)target);
        }
    }
    ,
    GL15_MAP{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.OpenGL15;
        }

        @Override
        public void mapBuffer(int target, int offset, int length, Consumer<ByteBuffer> upload) {
            ByteBuffer buffer = GL15.glMapBuffer((int)target, (int)35001);
            buffer.position(offset);
            upload.accept(buffer);
            buffer.rewind();
            GL15.glUnmapBuffer((int)target);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public boolean supported(GLCapabilities caps) {
            return true;
        }

        @Override
        public void mapBuffer(int target, int offset, int length, Consumer<ByteBuffer> upload) {
            throw new UnsupportedOperationException("glMapBuffer not supported");
        }
    };


    public abstract void mapBuffer(int var1, int var2, int var3, Consumer<ByteBuffer> var4);
}

