/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util;

import flash.minechess.client.gui.screen.BoardScreen;
import flash.minechess.client.gui.screen.ColorPickerScreen;
import flash.minechess.main.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtil {
    private static FileWriter fw;

    public static void save(int whiteColor, int blackColor, int highlightColor) {
        try {
            String path = new File(".").getCanonicalPath();
            File directory = new File(path + "/" + "minechess");
            if (!directory.exists()) {
                Main.LOGGER.debug("Created MineChess directory");
                directory.mkdirs();
            }
            File colorFile = new File(path + "/" + "minechess" + "/colors");
            fw = new FileWriter(colorFile);
            fw.write(whiteColor + "\n" + blackColor + "\n" + highlightColor);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Main.LOGGER.debug("Couldn't export colors: " + e.getMessage());
        }
    }

    public static void read() {
        try {
            File colorFile;
            String path = new File(".").getCanonicalPath();
            File directory = new File(path + "/" + "minechess");
            if (!directory.exists()) {
                Main.LOGGER.debug("Created MineChess directory");
                directory.mkdirs();
            }
            if ((colorFile = new File(path + "/" + "minechess" + "/colors")).exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(colorFile)));
                block7: for (int i = 0; i < 3; ++i) {
                    String s = reader.readLine();
                    int color = Integer.parseInt(s);
                    switch (i) {
                        case 0: {
                            BoardScreen.whiteColor = color;
                            ColorPickerScreen.whiteColor = color;
                            continue block7;
                        }
                        case 1: {
                            BoardScreen.blackColor = color;
                            ColorPickerScreen.blackColor = color;
                            continue block7;
                        }
                        case 2: {
                            BoardScreen.highlightedColor = color;
                            ColorPickerScreen.highlightedColor = color;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Main.LOGGER.debug("Couldn't load colors: " + e.getMessage());
        }
    }
}

