/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.util.chess.BoardRepresentation;
import flash.minechess.util.chess.Coord;
import java.util.ArrayList;

public class PrecomputedMoveData {
    public static final int[] directionOffsets = new int[]{8, -8, -1, 1, 7, -7, 9, -9};
    public static final int[][] numSquaresToEdge;
    public static final Byte[][] knightMoves;
    public static final Byte[][] kingMoves;
    public static final byte[][] pawnAttackDirections;
    public static final Integer[][] pawnAttacksWhite;
    public static final Integer[][] pawnAttacksBlack;
    public static final int[] directionLookup;
    public static final long[] kingAttackBitboards;
    public static final long[] knightAttackBitboards;
    public static final long[][] pawnAttackBitboards;
    public static final long[] rookMoves;
    public static final long[] bishopMoves;
    public static final long[] queenMoves;
    public static int[][] orthogonalDistance;
    public static int[][] kingDistance;
    public static int[] centreManhattanDistance;

    public static int numRookMovesToReachSquare(int startSquare, int targetSquare) {
        return orthogonalDistance[startSquare][targetSquare];
    }

    public static int numKingMovesToReachSquare(int startSquare, int targetSquare) {
        return kingDistance[startSquare][targetSquare];
    }

    static {
        pawnAttackDirections = new byte[][]{{4, 6}, {7, 5}};
        pawnAttacksWhite = new Integer[64][];
        pawnAttacksBlack = new Integer[64][];
        knightMoves = new Byte[64][];
        kingMoves = new Byte[64][];
        numSquaresToEdge = new int[64][];
        rookMoves = new long[64];
        bishopMoves = new long[64];
        queenMoves = new long[64];
        int[] allKnightJumps = new int[]{15, 17, -17, -15, 10, -6, 6, -10};
        knightAttackBitboards = new long[64];
        kingAttackBitboards = new long[64];
        pawnAttackBitboards = new long[64][];
        for (int squareIndex = 0; squareIndex < 64; ++squareIndex) {
            int targetSquare;
            int n;
            int currentDirOffset;
            int directionIndex;
            int y = squareIndex / 8;
            int x = squareIndex - y * 8;
            int north = 7 - y;
            int south = y;
            int west = x;
            int east = 7 - x;
            PrecomputedMoveData.numSquaresToEdge[squareIndex] = new int[8];
            PrecomputedMoveData.numSquaresToEdge[squareIndex][0] = north;
            PrecomputedMoveData.numSquaresToEdge[squareIndex][1] = south;
            PrecomputedMoveData.numSquaresToEdge[squareIndex][2] = west;
            PrecomputedMoveData.numSquaresToEdge[squareIndex][3] = east;
            PrecomputedMoveData.numSquaresToEdge[squareIndex][4] = Math.min(north, west);
            PrecomputedMoveData.numSquaresToEdge[squareIndex][5] = Math.min(south, east);
            PrecomputedMoveData.numSquaresToEdge[squareIndex][6] = Math.min(north, east);
            PrecomputedMoveData.numSquaresToEdge[squareIndex][7] = Math.min(south, west);
            ArrayList<Byte> legalKnightJumps = new ArrayList<Byte>();
            long knightBitboard = 0L;
            for (int knightJumpDelta : allKnightJumps) {
                int knightSquareY;
                int knightSquareX;
                int maxCoordMoveDst;
                int knightJumpSquare = squareIndex + knightJumpDelta;
                if (knightJumpSquare < 0 || knightJumpSquare >= 64 || (maxCoordMoveDst = Math.max(Math.abs(x - (knightSquareX = knightJumpSquare - (knightSquareY = knightJumpSquare / 8) * 8)), Math.abs(y - knightSquareY))) != 2) continue;
                legalKnightJumps.add((byte)knightJumpSquare);
                knightBitboard |= 1L << knightJumpSquare;
            }
            PrecomputedMoveData.knightMoves[squareIndex] = legalKnightJumps.toArray(new Byte[0]);
            PrecomputedMoveData.knightAttackBitboards[squareIndex] = knightBitboard;
            ArrayList<Byte> legalKingMoves = new ArrayList<Byte>();
            int[] nArray = directionOffsets;
            int n2 = nArray.length;
            for (int knightJumpDelta = 0; knightJumpDelta < n2; ++knightJumpDelta) {
                int kingSquareY;
                int kingSquareX;
                int maxCoordMoveDst;
                int kingMoveDelta = nArray[knightJumpDelta];
                int kingMoveSquare = squareIndex + kingMoveDelta;
                if (kingMoveSquare < 0 || kingMoveSquare >= 64 || (maxCoordMoveDst = Math.max(Math.abs(x - (kingSquareX = kingMoveSquare - (kingSquareY = kingMoveSquare / 8) * 8)), Math.abs(y - kingSquareY))) != 1) continue;
                legalKingMoves.add((byte)kingMoveSquare);
                int n3 = squareIndex;
                kingAttackBitboards[n3] = kingAttackBitboards[n3] | 1L << kingMoveSquare;
            }
            PrecomputedMoveData.kingMoves[squareIndex] = legalKingMoves.toArray(new Byte[0]);
            ArrayList<Integer> pawnCapturesWhite = new ArrayList<Integer>();
            ArrayList<Integer> pawnCapturesBlack = new ArrayList<Integer>();
            PrecomputedMoveData.pawnAttackBitboards[squareIndex] = new long[2];
            if (x > 0) {
                if (y < 7) {
                    pawnCapturesWhite.add(squareIndex + 7);
                    long[] lArray = pawnAttackBitboards[squareIndex];
                    lArray[0] = lArray[0] | 1L << squareIndex + 7;
                }
                if (y > 0) {
                    pawnCapturesBlack.add(squareIndex - 9);
                    long[] lArray = pawnAttackBitboards[squareIndex];
                    lArray[1] = lArray[1] | 1L << squareIndex - 9;
                }
            }
            if (x < 7) {
                if (y < 7) {
                    pawnCapturesWhite.add(squareIndex + 9);
                    long[] lArray = pawnAttackBitboards[squareIndex];
                    lArray[0] = lArray[0] | 1L << squareIndex + 9;
                }
                if (y > 0) {
                    pawnCapturesBlack.add(squareIndex - 7);
                    long[] lArray = pawnAttackBitboards[squareIndex];
                    lArray[1] = lArray[1] | 1L << squareIndex - 7;
                }
            }
            PrecomputedMoveData.pawnAttacksWhite[squareIndex] = pawnCapturesWhite.toArray(new Integer[0]);
            PrecomputedMoveData.pawnAttacksBlack[squareIndex] = pawnCapturesBlack.toArray(new Integer[0]);
            for (directionIndex = 0; directionIndex < 4; ++directionIndex) {
                currentDirOffset = directionOffsets[directionIndex];
                for (n = 0; n < numSquaresToEdge[squareIndex][directionIndex]; ++n) {
                    targetSquare = squareIndex + currentDirOffset * (n + 1);
                    int n4 = squareIndex;
                    rookMoves[n4] = rookMoves[n4] | 1L << targetSquare;
                }
            }
            for (directionIndex = 4; directionIndex < 8; ++directionIndex) {
                currentDirOffset = directionOffsets[directionIndex];
                for (n = 0; n < numSquaresToEdge[squareIndex][directionIndex]; ++n) {
                    targetSquare = squareIndex + currentDirOffset * (n + 1);
                    int n5 = squareIndex;
                    bishopMoves[n5] = bishopMoves[n5] | 1L << targetSquare;
                }
            }
            PrecomputedMoveData.queenMoves[squareIndex] = rookMoves[squareIndex] | bishopMoves[squareIndex];
        }
        directionLookup = new int[127];
        for (int i = 0; i < 127; ++i) {
            int offset = i - 63;
            int absOffset = Math.abs(offset);
            int absDir = 1;
            if (absOffset % 9 == 0) {
                absDir = 9;
            } else if (absOffset % 8 == 0) {
                absDir = 8;
            } else if (absOffset % 7 == 0) {
                absDir = 7;
            }
            PrecomputedMoveData.directionLookup[i] = absDir * Integer.signum(offset);
        }
        orthogonalDistance = new int[64][64];
        kingDistance = new int[64][64];
        centreManhattanDistance = new int[64];
        for (int squareA = 0; squareA < 64; ++squareA) {
            Coord coordA = BoardRepresentation.coordFromIndex(squareA);
            int fileDstFromCentre = Math.max(3 - coordA.fileIndex, coordA.fileIndex - 4);
            int rankDstFromCentre = Math.max(3 - coordA.rankIndex, coordA.rankIndex - 4);
            PrecomputedMoveData.centreManhattanDistance[squareA] = fileDstFromCentre + rankDstFromCentre;
            for (int squareB = 0; squareB < 64; ++squareB) {
                Coord coordB = BoardRepresentation.coordFromIndex(squareB);
                int rankDistance = Math.abs(coordA.rankIndex - coordB.rankIndex);
                int fileDistance = Math.abs(coordA.fileIndex - coordB.fileIndex);
                PrecomputedMoveData.orthogonalDistance[squareA][squareB] = fileDistance + rankDistance;
                PrecomputedMoveData.kingDistance[squareA][squareB] = Math.max(fileDistance, rankDistance);
            }
        }
    }
}

